/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionTooBigFile;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;

public class DefaultFileData
implements FileData {
    UploadPolicy uploadPolicy;
    boolean preparedForUpload = false;
    private static final int BUFLEN = 4096;
    protected String mimeType = "application/octet-stream";
    protected File file;
    protected long fileSize;
    protected String fileDir;
    protected String fileRoot = "";
    protected Date fileModified;
    protected String md5sum = null;
    protected Boolean canRead = null;

    public DefaultFileData(File file, File root, UploadPolicy uploadPolicy) {
        this.file = file;
        this.uploadPolicy = uploadPolicy;
        this.fileSize = this.file.length();
        this.fileDir = this.file.getAbsoluteFile().getParent();
        this.fileModified = new Date(this.file.lastModified());
        if (null != root) {
            this.fileRoot = root.getAbsolutePath();
            uploadPolicy.displayDebug("Creation of the DefaultFileData for " + file.getAbsolutePath() + "(root: " + root.getAbsolutePath() + ")", 10);
        } else {
            uploadPolicy.displayDebug("Creation of the DefaultFileData for " + file.getAbsolutePath() + "(root: null)", 10);
        }
        this.mimeType = this.uploadPolicy.getContext().getMimeType(this.getFileExtension());
    }

    public void appendFileProperties(ByteArrayEncoder bae, int index) throws JUploadIOException {
        bae.appendTextProperty("mimetype", this.getMimeType(), index);
        bae.appendTextProperty("pathinfo", this.getDirectory(), index);
        bae.appendTextProperty("relpathinfo", this.getRelativeDir(), index);
        SimpleDateFormat dateformat = new SimpleDateFormat(this.uploadPolicy.getDateFormat());
        String uploadFileModificationDate = dateformat.format(this.getLastModified());
        bae.appendTextProperty("filemodificationdate", uploadFileModificationDate, index);
    }

    public synchronized void beforeUpload() throws JUploadException {
        if (this.preparedForUpload) {
            this.uploadPolicy.displayWarn("The file " + this.getFileName() + " is already prepared for upload");
        } else {
            this.preparedForUpload = true;
            if (this.uploadPolicy.getSendMD5Sum()) {
                this.calculateMD5Sum();
            }
            if (this.getUploadLength() > this.uploadPolicy.getMaxFileSize()) {
                throw new JUploadExceptionTooBigFile(this.getFileName(), this.getUploadLength(), this.uploadPolicy);
            }
        }
    }

    public long getUploadLength() {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        return this.fileSize;
    }

    public synchronized void afterUpload() {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        this.md5sum = null;
        this.preparedForUpload = false;
    }

    public synchronized InputStream getInputStream() throws JUploadException {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new JUploadIOException(e);
        }
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getFileExtension() {
        return DefaultFileData.getExtension(this.file);
    }

    public long getFileLength() {
        return this.fileSize;
    }

    public Date getLastModified() {
        return this.fileModified;
    }

    public String getDirectory() {
        return this.fileDir;
    }

    public String getMD5() throws JUploadException {
        if (this.md5sum == null) {
            throw new JUploadException("The MD5Sum has not been calculated!");
        }
        return this.md5sum;
    }

    public void calculateMD5Sum() throws JUploadException {
        StringBuffer ret = new StringBuffer();
        MessageDigest digest = null;
        byte[] md5Buffer = new byte[4096];
        InputStream md5InputStream = this.getInputStream();
        try {
            int nbBytes;
            digest = MessageDigest.getInstance("MD5");
            while ((nbBytes = md5InputStream.read(md5Buffer, 0, 4096)) > 0) {
                digest.update(md5Buffer, 0, nbBytes);
            }
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JUploadException(e);
        }
        finally {
            try {
                md5InputStream.close();
            }
            catch (IOException e) {
                throw new JUploadIOException(e);
            }
        }
        byte[] md5sum = new byte[32];
        if (digest != null) {
            md5sum = digest.digest();
        }
        for (int i = 0; i < md5sum.length; ++i) {
            ret.append(Integer.toHexString(md5sum[i] >> 4 & 0xF));
            ret.append(Integer.toHexString(md5sum[i] & 0xF));
        }
        this.md5sum = ret.toString();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean canRead() {
        if (this.canRead == null) {
            try {
                FileInputStream is = new FileInputStream(this.file);
                ((InputStream)is).close();
                this.canRead = true;
            }
            catch (IOException e) {
                this.canRead = false;
            }
        }
        return this.canRead;
    }

    public File getFile() {
        return this.file;
    }

    public String getRelativeDir() {
        if (null != this.fileRoot && !this.fileRoot.equals("") && this.fileDir.startsWith(this.fileRoot)) {
            int skip = this.fileRoot.length();
            if (!this.fileRoot.endsWith(File.separator)) {
                ++skip;
            }
            if (skip >= 0 && skip < this.fileDir.length()) {
                return this.fileDir.substring(skip);
            }
        }
        return "";
    }

    public static String getExtension(File file) {
        String name = file.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static File getRoot(File[] fileArray) {
        File root = fileArray[0];
        if (root.isDirectory()) {
            root = root.getParentFile();
        }
        while (root != null && !root.isDirectory()) {
            root = root.getParentFile();
        }
        if (root != null) {
            String pathRoot = root.getAbsolutePath() + File.separator;
            for (int i = 1; i < fileArray.length && root != null; ++i) {
                File pathCurrentFileParent;
                String pathCurrentFileParentPath = pathCurrentFileParent.getAbsolutePath() + File.separator;
                for (pathCurrentFileParent = fileArray[i]; pathCurrentFileParent != null && !pathRoot.startsWith(pathCurrentFileParentPath); pathCurrentFileParent = pathCurrentFileParent.getParentFile()) {
                    pathCurrentFileParentPath = pathCurrentFileParent.getAbsolutePath() + File.separator;
                }
                root = pathCurrentFileParent;
                pathRoot = pathCurrentFileParentPath;
            }
            root = new File(pathRoot);
        }
        return root;
    }

    public boolean isPreparedForUpload() {
        return this.preparedForUpload;
    }
}

